 ; Ŀ
 ;   Ploot - Plot utility.                                                 
 ;   Copyright 2001, 2002 by Rocket Software Ltd.                          
 ;                                                                         
 ; 

 ; Ŀ
 ;   Fisp - find out which space the title block occupies.                 
 ;   Takes no arguments, returns either "Model" or "Paper", indicating     
 ;   the space to plot.                                                    
 ;   Contains an internal list of blocks, if any one is found in the       
 ;   drawing then the space it occupies is taken as the one to plot.       
 ;   No provision is made for choosing between multiple paper space        
 ;   layouts.                                                              
 ; 
 (DEFUN FISP (/ tblist blnam ss enam space prisp)
  (setq tblist '("icaltblk" "d-bord-e" "GCA1TB"))
  (while (and (setq blnam (car tblist))
              (or (null (tblsearch "block" blnam))
                  (null (setq ss (ssget "x" (list (cons 2 blnam)))))))
         (setq tblist (cdr tblist)))
  (cond ((null ss)
         (setq prisp "Model"))
        ((and (setq enam (ssname ss 0))
              (setq space (cdr (assoc 67 (entget enam))))
              (= space 1))
         (setq prisp "Paper"))
        (T
         (setq prisp "Model")))
 prisp)
 ; Ŀ
 ;   Fisp end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Enplot - plot 11 x 17 in model space.                      
 ;   Takes no arguments, returns nothing, calls nothing.                   
 ; 
 (DEFUN ENPLOT ()
  (command "plot")
  (command "y")                               ; detailed plot configuration?
  (command "Model")                           ; layout name <Model>:
  (command "8-P06.pc3")                       ; output device name
  (command "11x17")                           ; paper size
  (command "Inches")                          ; paper units
  (command "Landscape")                       ; dwg orientation
  (command "N")                               ; plot upside down?
  (command "Extents")                         ; plot area
  (command "Fit")                             ; plot scale
  (command "Center")                          ; plot offset
  (command "Yes")                             ; plot with plot styles?
  (command "LASER.ctb")                       ; plot style table (. for none)
  (command "Y")                               ; plot with lineweights?
  (command "N")                               ; remove hidden lines?
  (command "N")                               ; plot to a file?
  (command "N")                               ; Save changes to model tab?
  (command "Y")                               ; Proceed with plot?
 (princ))
 ; Ŀ
 ;   Subroutine Enplot end.                                                
 ; 

 ; Ŀ
 ;   Subroutine Pplot - plot 11 x 17 in paper space.                       
 ;   Takes no arguments, returns nothing, calls nothing.                   
 ; 
 (DEFUN PPLOT ()
  (command "plot")
  (command "y")                               ; detailed plot configuration?
  (command "")                                ; layout name or [?] <Layout1>
  (command "8-P06.pc3")                       ; output device name
  (command "11x17")                           ; paper size
  (command "Millimeters")                     ; paper units
  (command "Landscape")                       ; dwg orientation
  (command "N")                               ; plot upside down?
  (command "Extents")                         ; plot area
  (command "Fit")                             ; plot scale
  (command "Center")                          ; plot offset
  (command "Yes")                             ; plot with plot styles?
  (command "LASER.ctb")                       ; plot style table (. for none)
  (command "Y")                               ; plot with lineweights?
  (command "N")                               ; Scale linewgts with plot scale?
  (command "N")                               ; Plot paper space first?
  (command "N")                               ; remove hidden lines?
  (command "N")                               ; plot to a file?
  (command "Y")                               ; Save changes to layout?
  (command "Y")                               ; Proceed with plot?
 (princ))
 ; Ŀ
 ;   Subroutine Enplot end.                                                
 ; 

 ; Ŀ
 ;   Ploot.                                                                
 ; 
 (DEFUN C:PLOOT ()
  (if (= "Model" (fisp))
      (progn
           (setvar "tilemode" 1)
           (enplot))
      (progn
           (setvar "tilemode" 0)
           (pplot)))
 (princ))